/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals;

import com.almostreliable.summoningrituals.altar.AltarBlock;
import com.almostreliable.summoningrituals.altar.AltarEntity;
import com.almostreliable.summoningrituals.recipe.AltarRecipe;
import com.almostreliable.summoningrituals.recipe.AltarRecipeSerializer;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryObject;

public final class Setup {
    private static final DeferredRegister<Block> BLOCKS = Setup.createRegistry(ForgeRegistries.BLOCKS);
    private static final DeferredRegister<Item> ITEMS = Setup.createRegistry(ForgeRegistries.ITEMS);
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = Setup.createRegistry(ForgeRegistries.BLOCK_ENTITIES);
    private static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((ResourceKey)Registry.f_122914_, (String)"summoningrituals");
    private static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = Setup.createRegistry(ForgeRegistries.RECIPE_SERIALIZERS);
    private static final Tab TAB = new Tab("summoningrituals");
    public static final RegistryObject<AltarBlock> ALTAR_BLOCK = BLOCKS.register("altar", () -> new AltarBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(2.5f).m_60918_(SoundType.f_56742_)));
    public static final RegistryObject<AltarBlock> INDESTRUCTIBLE_ALTAR_BLOCK = BLOCKS.register("indestructible_altar", () -> new AltarBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(-1.0f, 3600000.0f).m_60918_(SoundType.f_56742_)));
    public static final RegistryObject<Item> ALTAR_ITEM = ITEMS.register("altar", () -> new BlockItem((Block)ALTAR_BLOCK.get(), new Item.Properties().m_41491_((CreativeModeTab)TAB)));
    public static final RegistryObject<Item> INDESTRUCTIBLE_ALTAR_ITEM = ITEMS.register("indestructible_altar", () -> new BlockItem((Block)INDESTRUCTIBLE_ALTAR_BLOCK.get(), new Item.Properties().m_41491_((CreativeModeTab)TAB)));
    public static final RegistryObject<BlockEntityType<AltarEntity>> ALTAR_ENTITY = BLOCK_ENTITIES.register("altar", () -> BlockEntityType.Builder.m_155273_(AltarEntity::new, (Block[])new Block[]{(Block)ALTAR_BLOCK.get(), (Block)INDESTRUCTIBLE_ALTAR_BLOCK.get()}).m_58966_(null));
    public static final RecipeEntry<AltarRecipe> ALTAR_RECIPE = RecipeEntry.register("altar", AltarRecipeSerializer::new);

    private Setup() {
    }

    static void init(IEventBus modEventBus) {
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        BLOCK_ENTITIES.register(modEventBus);
        RECIPE_TYPES.register(modEventBus);
        RECIPE_SERIALIZERS.register(modEventBus);
    }

    private static <T extends IForgeRegistryEntry<T>> DeferredRegister<T> createRegistry(IForgeRegistry<T> registry) {
        return DeferredRegister.create(registry, (String)"summoningrituals");
    }

    private static final class Tab
    extends CreativeModeTab {
        private Tab(String label) {
            super(label);
        }

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)ALTAR_ITEM.get());
        }
    }

    public record RecipeEntry<T extends Recipe<?>>(RegistryObject<RecipeType<T>> type, RegistryObject<RecipeSerializer<T>> serializer) {
        private static <T extends Recipe<?>> RecipeEntry<T> register(final String id, Supplier<? extends RecipeSerializer<T>> serializer) {
            RegistryObject type = RECIPE_TYPES.register(id, () -> new RecipeType<T>(){

                public String toString() {
                    return id;
                }
            });
            return new RecipeEntry<T>(type, RECIPE_SERIALIZERS.register(id, serializer));
        }
    }
}

